"""Auto-generated stub file for GTA V ScriptHookVDotNet"""

from typing import Any, List, Dict, Optional, Iterable, ClassVar, Tuple, Callable, TypeVar, overload, Union
from enum import Enum

from GTA import (
    Blip,
    Camera,
    Checkpoint,
    Entity,
    FeedPost,
    Game,
    Model,
    Ped,
    PedHash,
    Player,
    Prop,
    Vehicle,
    VehicleHash,
    Weapon,
    WeaponHash,
    World
)
from GTA.Graphics import TextureAsset
from GTA.Math import Matrix, Quaternion, Vector2, Vector3

class Alignment(Enum):
    Center = 0
    Left = 1
    Right = 2

class ContainerElement:
    Enabled: bool
    Color: Any
    Position: Any
    Size: Any
    Centered: bool
    Items: List[IElement]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position: Any, size: Any) -> None: ...
    @overload
    def __init__(self, position: Any, size: Any, color: Any) -> None: ...
    @overload
    def __init__(self, position: Any, size: Any, color: Any, centered: bool) -> None: ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    @overload
    def Draw(self) -> None: ...
    @overload
    def Draw(self, offset: Any) -> None: ...
    def Draw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def ScaledDraw(self) -> None: ...
    @overload
    def ScaledDraw(self, offset: Any) -> None: ...
    def ScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldScaledDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldScaledDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...

class CursorSprite(Enum):
    Normal = 1
    LightArrow = 2
    OpenHand = 3
    GrabHand = 4
    MiddleFinger = 5
    LeftArrow = 6
    RightArrow = 7
    UpArrow = 8
    DownArrow = 9
    HorizontalDoubleArrow = 10
    NormalWithPlus = 11
    NormalWithMinus = 12

class CustomSprite:
    Enabled: bool
    Color: Any
    Position: Any
    Size: Any
    Rotation: float
    Centered: bool
    @overload
    def __init__(self, filename: str, size: Any, position: Any) -> None: ...
    @overload
    def __init__(self, filename: str, size: Any, position: Any, color: Any) -> None: ...
    @overload
    def __init__(self, filename: str, size: Any, position: Any, color: Any, rotation: float) -> None: ...
    @overload
    def __init__(self, filename: str, size: Any, position: Any, color: Any, rotation: float, centered: bool) -> None: ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    @overload
    def Draw(self) -> None: ...
    @overload
    def Draw(self, offset: Any) -> None: ...
    def Draw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def ScaledDraw(self) -> None: ...
    @overload
    def ScaledDraw(self, offset: Any) -> None: ...
    def ScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldScaledDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldScaledDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...

class FeedTextIcon(Enum):
    Blank = 0
    Message = 1
    Email = 2
    NewContact = 3
    Driver = 4
    Hacker = 5
    Shooter = 6
    Invite = 7
    RP = 8
    Cash = 9
    AP = 10
    XPAlt = 11
    CashAlt = 12

class FeedUnlockIcon(Enum):
    Haircut = 0
    Tattoo = 1
    Weapon = 2
    WeaponPlus = 3
    Armor = 4
    Vehicle = 5
    Mask = 6
    Clothes = 7
    Kit = 8
    Makeup = 9
    Bag = 10
    BusinessProperty = 11
    USFlag = 12
    USProperty = 13
    Anchor = 14
    Plane = 15
    Heli = 16
    Bike = 17
    Discount = 18
    Mystery = 19
    Arcade = 20
    Invalid = -1

class Font(Enum):
    ChaletLondon = 0
    HouseScript = 1
    RockstarTag = 2
    Monospace = 2
    Leaderboard = 3
    ChaletComprimeCologne = 4
    FixedWidthNumbersStyle = 5
    ChaletComprimeCologneNotGamerName = 6
    Pricedown = 7
    Taxi = 8

class Hud:
    CursorSprite: ClassVar[CursorSprite]
    IsVisible: ClassVar[bool]
    IsRadarVisible: ClassVar[bool]
    RadarZoom: int
    @staticmethod
    def IsComponentActive(component: HudComponent) -> bool: ...
    @staticmethod
    def ShowComponentThisFrame(component: HudComponent) -> None: ...
    @staticmethod
    def HideComponentThisFrame(component: HudComponent) -> None: ...
    @staticmethod
    def ShowCursorThisFrame() -> None: ...
    @staticmethod
    def LockRadarDirection(angle: int) -> None: ...
    @staticmethod
    def UnlockRadarDirection() -> None: ...
    @staticmethod
    def LockRadarPosition(position: Vector2) -> None: ...
    @staticmethod
    def UnlockRadarPosition() -> None: ...

class HudColor(Enum):
    PureWhite = 0
    White = 1
    Black = 2
    Gray = 3
    GrayLight = 4
    GrayDark = 5
    Red = 6
    RedLight = 7
    RedDark = 8
    Blue = 9
    BlueLight = 10
    BlueDark = 11
    Yellow = 12
    YellowLight = 13
    YellowDark = 14
    Orange = 15
    OrangeLight = 16
    OrangeDark = 17
    Green = 18
    GreenLight = 19
    GreenDark = 20
    Purple = 21
    PurpleLight = 22
    PurpleDark = 23
    Pink = 24
    RadarHealth = 25
    RadarArmor = 26
    RadarDamage = 27
    NetPlayer1 = 28
    NetPlayer2 = 29
    NetPlayer3 = 30
    NetPlayer4 = 31
    NetPlayer5 = 32
    NetPlayer6 = 33
    NetPlayer7 = 34
    NetPlayer8 = 35
    NetPlayer9 = 36
    NetPlayer10 = 37
    NetPlayer11 = 38
    NetPlayer12 = 39
    NetPlayer13 = 40
    NetPlayer14 = 41
    NetPlayer15 = 42
    NetPlayer16 = 43
    NetPlayer17 = 44
    NetPlayer18 = 45
    NetPlayer19 = 46
    NetPlayer20 = 47
    NetPlayer21 = 48
    NetPlayer22 = 49
    NetPlayer23 = 50
    NetPlayer24 = 51
    NetPlayer25 = 52
    NetPlayer26 = 53
    NetPlayer27 = 54
    NetPlayer28 = 55
    NetPlayer29 = 56
    NetPlayer30 = 57
    NetPlayer31 = 58
    NetPlayer32 = 59
    SimpleBlipDefault = 60
    MenuBlue = 61
    MenuGrayLight = 62
    MenuBlueExtraDark = 63
    MenuYellow = 64
    MenuYellowDark = 65
    MenuGreen = 66
    MenuGray = 67
    MenuGrayDark = 68
    MenuHighlight = 69
    MenuStandard = 70
    MenuDimmed = 71
    MenuExtraDimmed = 72
    BriefTitle = 73
    MidGrayMP = 74
    NetPlayer1Dark = 75
    NetPlayer2Dark = 76
    NetPlayer3Dark = 77
    NetPlayer4Dark = 78
    NetPlayer5Dark = 79
    NetPlayer6Dark = 80
    NetPlayer7Dark = 81
    NetPlayer8Dark = 82
    NetPlayer9Dark = 83
    NetPlayer10Dark = 84
    NetPlayer11Dark = 85
    NetPlayer12Dark = 86
    NetPlayer13Dark = 87
    NetPlayer14Dark = 88
    NetPlayer15Dark = 89
    NetPlayer16Dark = 90
    NetPlayer17Dark = 91
    NetPlayer18Dark = 92
    NetPlayer19Dark = 93
    NetPlayer20Dark = 94
    NetPlayer21Dark = 95
    NetPlayer22Dark = 96
    NetPlayer23Dark = 97
    NetPlayer24Dark = 98
    NetPlayer25Dark = 99
    NetPlayer26Dark = 100
    NetPlayer27Dark = 101
    NetPlayer28Dark = 102
    NetPlayer29Dark = 103
    NetPlayer30Dark = 104
    NetPlayer31Dark = 105
    NetPlayer32Dark = 106
    Bronze = 107
    Silver = 108
    Gold = 109
    Platinum = 110
    Gang1 = 111
    Gang2 = 112
    Gang3 = 113
    Gang4 = 114
    SameCrew = 115
    Freemode = 116
    PauseBG = 117
    Friendly = 118
    Enemy = 119
    Location = 120
    Pickup = 121
    PauseSingleplayer = 122
    FreemodeDark = 123
    InactiveMission = 124
    Damage = 125
    PinkLight = 126
    PMMitemHighlight = 127
    ScriptVariable = 128
    Yoga = 129
    Tennis = 130
    Golf = 131
    ShootingRange = 132
    FlightSchool = 133
    NorthBlue = 134
    SocialClub = 135
    PlatformBlue = 136
    PlatformGreen = 137
    PlatformGray = 138
    FacebookBlue = 139
    IngameBG = 140
    Darts = 141
    Waypoint = 142
    Michael = 143
    Franklin = 144
    Trevor = 145
    GolfP1 = 146
    GolfP2 = 147
    GolfP3 = 148
    GolfP4 = 149
    WaypointLight = 150
    WaypointDark = 151
    PanelLight = 152
    MichaelDark = 153
    FranklinDark = 154
    TrevorDark = 155
    ObjectiveRoute = 156
    PauseMapTint = 157
    PauseDeselect = 158
    PMWeaponsPurchasable = 159
    PMWeaponsLocked = 160
    EndScreenBG = 161
    Chop = 162
    PauseMapTintHalf = 163
    NorthBlueOfficial = 164
    ScriptVariable2 = 165
    H = 166
    HDark = 167
    T = 168
    TDark = 169
    HShard = 170
    ControllerMichael = 171
    ControllerFranklin = 172
    ControllerTrevor = 173
    ControllerChop = 174
    VideoEditorVideo = 175
    VideoEditorAudio = 176
    VideoEditorText = 177
    HBBlue = 178
    HBYellow = 179
    VideoEditorScore = 180
    VideoEditorAudioFadeout = 181
    VideoEditorTextFadeout = 182
    VideoEditorScoreFadeout = 183
    HeistBackground = 184
    VideoEditorAmbient = 185
    VideoEditorAmbientFadeout = 186
    VideoEditorAmbientDark = 187
    VideoEditorAmbientLight = 188
    VideoEditorAmbientMid = 189
    LowFlow = 190
    LowFlowDark = 191
    G1 = 192
    G2 = 193
    G3 = 194
    G4 = 195
    G5 = 196
    G6 = 197
    G7 = 198
    G8 = 199
    G9 = 200
    G10 = 201
    G11 = 202
    G12 = 203
    G13 = 204
    G14 = 205
    G15 = 206
    Adversary = 207
    DegenRed = 208
    DegenYellow = 209
    DegenGreen = 210
    DegenCyan = 211
    DegenBlue = 212
    DegenMagenta = 213
    Stunt1 = 214
    Stunt2 = 215
    SpecialRaceSeries = 216
    SpecialRaceSeriesDark = 217
    CS = 218
    CSDark = 219
    TechGreen = 220
    TechGreenDark = 221
    TechRed = 222
    TechGreenVeryDark = 223
    Invalid = -1

class HudComponent(Enum):
    WantedStars = 1
    WeaponIcon = 2
    Cash = 3
    MpCash = 4
    MpMessage = 5
    VehicleName = 6
    AreaName = 7
    Unused = 8
    StreetName = 9
    HelpText = 10
    FloatingHelpText1 = 11
    FloatingHelpText2 = 12
    CashChange = 13
    Reticle = 14
    SubtitleText = 15
    RadioStationsWheel = 16
    Saving = 17
    GamingStreamUnusde = 18
    WeaponWheel = 19
    WeaponWheelStats = 20
    DrugsPurse01 = 21
    DrugsPurse02 = 22
    DrugsPurse03 = 23
    DrugsPurse04 = 24
    MpTagCashFromBank = 25
    MpTagPackages = 26
    MpTagCuffKeys = 27
    MpTagDownloadData = 28
    MpTagIfPedFollowing = 29
    MpTagKeyCard = 30
    MpTagRandomObject = 31
    MpTagRemoteControl = 32
    MpTagCashFromSafe = 33
    MpTagWeaponsPackage = 34
    MpTagKeys = 35
    MpVehicle = 36
    MpVehicleHeli = 37
    MpVehiclePlane = 38
    PlayerSwitchAlert = 39
    MpRankBar = 40
    DirectorMode = 41
    ReplayController = 42
    ReplayMouse = 43
    ReplayHeader = 44
    ReplayOptions = 45
    ReplayHelpText = 46
    ReplayMiscText = 47
    ReplayTopLine = 48
    ReplayBottomLine = 49
    ReplayLeftBar = 50
    ReplayTimer = 51

class LoadingPrompt:
    IsActive: ClassVar[bool]
    @staticmethod
    def Show(loadingText: Optional[str] = None, spinnerType: LoadingSpinnerType = ...) -> None: ...
    @staticmethod
    def Hide() -> None: ...

class LoadingSpinnerType(Enum):
    Clockwise1 = 1
    Clockwise2 = 2
    Clockwise3 = 3
    SocialClubSaving = 4
    RegularClockwise = 5

class Notification:
    @staticmethod
    def PostTicker(message: str, isImportant: bool, cacheMessage: bool = True) -> FeedPost: ...
    @staticmethod
    def PostTickerForced(message: str, isImportant: bool, cacheMessage: bool = True) -> FeedPost: ...
    @staticmethod
    def PostTickerWithTokens(message: str, isImportant: bool, cacheMessage: bool = True) -> FeedPost: ...
    @staticmethod
    def PostMessageText(message: str, texAsset: TextureAsset, isImportant: bool, icon: FeedTextIcon, characterName: str, subtitle: Optional[str] = None) -> FeedPost: ...
    @staticmethod
    def PostUnlock(message: str, title: str, iconType: FeedUnlockIcon) -> FeedPost: ...
    @staticmethod
    def PostUnlockTitleUpdate(message: str, title: str, iconType: FeedUnlockIcon, isImportant: bool = True) -> FeedPost: ...
    @staticmethod
    def PostUnlockTitleUpdateWithColor(message: str, title: str, iconType: FeedUnlockIcon, isImportant: bool = True, titleColor: HudColor = ..., titleIsLiteral: bool = True) -> FeedPost: ...
    @staticmethod
    def PostVersusTitleUpdate(char1TexAsset: TextureAsset, val1: int, char2TexAsset: TextureAsset, val2: int, customColor1: HudColor = ..., customColor2: HudColor = ...) -> FeedPost: ...
    @staticmethod
    def PostAward(message: str, texAsset: TextureAsset, xp: int, awardColor: HudColor, title: Optional[str] = None) -> FeedPost: ...
    @overload
    @staticmethod
    def Show(message: str, blinking: bool = False) -> int: ...
    @overload
    @staticmethod
    def Show(icon: NotificationIcon, sender: str, subject: str, message: str, fadeIn: bool = False, blinking: bool = False) -> int: ...
    @staticmethod
    def Show(*args: Any, **kwargs: Any) -> Any: ...
    @staticmethod
    def Hide(handle: int) -> None: ...

class NotificationIcon(Enum):
    Abigail = 0
    AllPlayersConf = 1
    Amanda = 2
    Ammunation = 3
    Andreas = 4
    Antonia = 5
    Arthur = 6
    Ashley = 7
    BankBol = 8
    BankFleeca = 9
    BankMaze = 10
    Barry = 11
    Beverly = 12
    Bikesite = 13
    BlankEntry = 14
    Blimp = 15
    Blocked = 16
    Boatsite = 17
    BrokenDownGirl = 18
    Bugstars = 19
    Call911 = 20
    Carsite = 21
    Carsite2 = 22
    Castro = 23
    ChatCall = 24
    Chef = 25
    Cheng = 26
    Chengsr = 27
    Chop = 28
    Cris = 29
    Dave = 30
    Default = 31
    Denise = 32
    DetonateBomb = 33
    DetonatePhone = 34
    Devin = 35
    DialASub = 36
    Dom = 37
    DomesticGirl = 38
    Dreyfuss = 39
    DrFriedlander = 40
    Epsilon = 41
    EstateAgent = 42
    Facebook = 43
    FilmNoir = 44
    Floyd = 45
    Franklin = 46
    FrankTrevConf = 47
    Gaymilitary = 48
    Hao = 49
    HitcherGirl = 50
    HumanDefault = 51
    Hunter = 52
    Jimmy = 53
    JimmyBoston = 54
    Joe = 55
    Josef = 56
    Josh = 57
    Lamar = 58
    Lazlow = 59
    Lester = 60
    LesterDeathwish = 61
    LesFrankConf = 62
    LesMikeConf = 63
    Lifeinvader = 64
    LsCustoms = 65
    LsTouristBoard = 66
    Manuel = 67
    Marnie = 68
    Martin = 69
    MaryAnn = 70
    Maude = 71
    Mechanic = 72
    Michael = 73
    MikeFrankConf = 74
    MikeTrevConf = 75
    Milsite = 76
    Minotaur = 77
    Molly = 78
    MpArmyContact = 79
    MpBikerBoss = 80
    MpBikerMechanic = 81
    MpBrucie = 82
    MpDetonatePhone = 83
    MpFamBoss = 84
    MpFIBContact = 85
    MpFmContact = 86
    MpGerald = 87
    MpJulio = 88
    MpMechanic = 89
    MpMerryweather = 90
    MpMexBoss = 91
    MpMexDocks = 92
    MpMexLt = 93
    MpMorsMutual = 94
    MpProfBoss = 95
    MpRayLavoy = 96
    MpRoberto = 97
    MpSnitch = 98
    MpStretch = 99
    MpStripclubPr = 100
    MrsThornhill = 101
    Multiplayer = 102
    Nigel = 103
    Omega = 104
    Oneil = 105
    Ortega = 106
    Oscar = 107
    Patricia = 108
    PegasusDelivery = 109
    Planesite = 110
    PropertyArmsTrafficking = 111
    PropertyBarAirport = 112
    PropertyBarBayview = 113
    PropertyBarCafeRojo = 114
    PropertyBarCockotoos = 115
    PropertyBarEclipse = 116
    PropertyBarFes = 117
    PropertyBarHenHouse = 118
    PropertyBarHiMen = 119
    PropertyBarHookies = 120
    PropertyBarIrish = 121
    PropertyBarLesBianco = 122
    PropertyBarMirrorPark = 123
    PropertyBarPitchers = 124
    PropertyBarSingletons = 125
    PropertyBarTequilala = 126
    PropertyBarUnbranded = 127
    PropertyCarModShop = 128
    PropertyCarScrapYard = 129
    PropertyCinemaDowntown = 130
    PropertyCinemaMorningwood = 131
    PropertyCinemaVinewood = 132
    PropertyGolfClub = 133
    PropertyPlaneScrapYard = 134
    PropertySonarCollections = 135
    PropertyTaxiLot = 136
    PropertyTowingImpound = 137
    PropertyWeedShop = 138
    Ron = 139
    Saeeda = 140
    Sasquatch = 141
    Simeon = 142
    SocialClub = 143
    Solomon = 144
    Steve = 145
    SteveMikeConf = 146
    SteveTrevConf = 147
    Stretch = 148
    StripperChastity = 149
    StripperCheetah = 150
    StripperFufu = 151
    StripperInfernus = 152
    StripperJuliet = 153
    StripperNikki = 154
    StripperPeach = 155
    StripperSapphire = 156
    Tanisha = 157
    Taxi = 158
    TaxiLiz = 159
    TennisCoach = 160
    TowTonya = 161
    Tracey = 162
    Trevor = 163
    Wade = 164
    YouTube = 165
    CreatorPortraits = 166

class Screen:
    Resolution: ClassVar[Any]
    MainWindowResolution: ClassVar[Any]
    AspectRatio: ClassVar[float]
    PhysicalAspectRatio: ClassVar[float]
    ScaledWidth: ClassVar[float]
    SafeZoneSizeProfile: ClassVar[int]
    IsFadedIn: ClassVar[bool]
    IsFadedOut: ClassVar[bool]
    IsFadingIn: ClassVar[bool]
    IsFadingOut: ClassVar[bool]
    AreScreenKillEffectsEnabled: ClassVar[bool]
    IsHelpTextDisplayed: ClassVar[bool]
    Width: ClassVar[float]
    Height: ClassVar[float]
    @staticmethod
    def FadeIn(time: int) -> None: ...
    @staticmethod
    def FadeOut(time: int) -> None: ...
    @staticmethod
    def IsEffectActive(effectName: ScreenEffect) -> bool: ...
    @staticmethod
    def StartEffect(effectName: ScreenEffect, duration: int = 0, looped: bool = False) -> None: ...
    @staticmethod
    def StopEffect(effectName: ScreenEffect) -> None: ...
    @staticmethod
    def StopEffects() -> None: ...
    @overload
    @staticmethod
    def ShowSubtitle(message: str, duration: int = 2500) -> None: ...
    @overload
    @staticmethod
    def ShowSubtitle(message: str, duration: int, drawImmediately: bool = True) -> None: ...
    @staticmethod
    def ShowSubtitle(*args: Any, **kwargs: Any) -> Any: ...
    @overload
    @staticmethod
    def ShowHelpTextThisFrame(helpText: str) -> None: ...
    @overload
    @staticmethod
    def ShowHelpTextThisFrame(helpText: str, beep: bool) -> None: ...
    @staticmethod
    def ShowHelpTextThisFrame(*args: Any, **kwargs: Any) -> Any: ...
    @staticmethod
    def ShowHelpText(helpText: str, duration: int = -1, beep: bool = True, looped: bool = False) -> None: ...
    @staticmethod
    def ClearHelpText() -> None: ...
    @staticmethod
    def IsSphereVisible(position: Vector3, radius: float) -> bool: ...
    @staticmethod
    def WorldToScreen(position: Vector3, scaleWidth: bool = False) -> Any: ...

class ScreenEffect(Enum):
    SwitchHudIn = 0
    SwitchHudOut = 1
    FocusIn = 2
    FocusOut = 3
    MinigameEndNeutral = 4
    MinigameEndTrevor = 5
    MinigameEndFranklin = 6
    MinigameEndMichael = 7
    MinigameTransitionOut = 8
    MinigameTransitionIn = 9
    SwitchShortNeutralIn = 10
    SwitchShortFranklinIn = 11
    SwitchShortTrevorIn = 12
    SwitchShortMichaelIn = 13
    SwitchOpenMichaelIn = 14
    SwitchOpenFranklinIn = 15
    SwitchOpenTrevorIn = 16
    SwitchHudMichaelOut = 17
    SwitchHudFranklinOut = 18
    SwitchHudTrevorOut = 19
    SwitchShortFranklinMid = 20
    SwitchShortMichaelMid = 21
    SwitchShortTrevorMid = 22
    DeathFailOut = 23
    CamPushInNeutral = 24
    CamPushInFranklin = 25
    CamPushInMichael = 26
    CamPushInTrevor = 27
    SwitchSceneFranklin = 28
    SwitchSceneTrevor = 29
    SwitchSceneMichael = 30
    SwitchSceneNeutral = 31
    MpCelebWin = 32
    MpCelebWinOut = 33
    MpCelebLose = 34
    MpCelebLoseOut = 35
    DeathFailNeutralIn = 36
    DeathFailMpDark = 37
    DeathFailMpIn = 38
    MpCelebPreloadFade = 39
    PeyoteEndOut = 40
    PeyoteEndIn = 41
    PeyoteIn = 42
    PeyoteOut = 43
    MpRaceCrash = 44
    SuccessFranklin = 45
    SuccessTrevor = 46
    SuccessMichael = 47
    DrugsMichaelAliensFightIn = 48
    DrugsMichaelAliensFight = 49
    DrugsMichaelAliensFightOut = 50
    DrugsTrevorClownsFightIn = 51
    DrugsTrevorClownsFight = 52
    DrugsTrevorClownsFightOut = 53
    HeistCelebPass = 54
    HeistCelebPassBw = 55
    HeistCelebEnd = 56
    HeistCelebToast = 57
    MenuMgHeistIn = 58
    MenuMgTournamentIn = 59
    MenuMgSelectionIn = 60
    ChopVision = 61
    DmtFlightIntro = 62
    DmtFlight = 63
    DrugsDrivingIn = 64
    DrugsDrivingOut = 65
    SwitchOpenNeutralFib5 = 66
    HeistLocate = 67
    MpJobLoad = 68
    RaceTurbo = 69
    MpIntroLogo = 70
    HeistTripSkipFade = 71
    MenuMgHeistOut = 72
    MpCoronaSwitch = 73
    MenuMgSelectionTint = 74
    SuccessNeutral = 75
    ExplosionJosh3 = 76
    SniperOverlay = 77
    RampageOut = 78
    Rampage = 79
    DontTazemeBro = 80

class Sprite:
    Enabled: bool
    Color: Any
    Position: Any
    TextureCoordinates: Any
    Size: Any
    Rotation: float
    Centered: bool
    @overload
    def __init__(self, textureDict: str, textureName: str, size: Any, position: Any) -> None: ...
    @overload
    def __init__(self, textureDict: str, textureName: str, size: Any, position: Any, color: Any) -> None: ...
    @overload
    def __init__(self, textureDict: str, textureName: str, size: Any, position: Any, color: Any, rotation: float) -> None: ...
    @overload
    def __init__(self, textureDict: str, textureName: str, size: Any, position: Any, color: Any, rotation: float, centered: bool) -> None: ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def Dispose(self) -> None: ...
    @overload
    def Draw(self) -> None: ...
    @overload
    def Draw(self, offset: Any) -> None: ...
    def Draw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def ScaledDraw(self) -> None: ...
    @overload
    def ScaledDraw(self, offset: Any) -> None: ...
    def ScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldScaledDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldScaledDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...

class TextElement:
    Enabled: bool
    Color: Any
    Position: Any
    Scale: float
    Font: Font
    Caption: str
    Alignment: Alignment
    Shadow: bool
    Outline: bool
    WrapWidth: float
    Centered: bool
    Width: float
    ScaledWidth: float
    LineCount: int
    ScaledLineCount: int
    @overload
    def __init__(self, caption: str, position: Any, scale: float) -> None: ...
    @overload
    def __init__(self, caption: str, position: Any, scale: float, color: Any) -> None: ...
    @overload
    def __init__(self, caption: str, position: Any, scale: float, color: Any, font: Font) -> None: ...
    @overload
    def __init__(self, caption: str, position: Any, scale: float, color: Any, font: Font, alignment: Alignment) -> None: ...
    @overload
    def __init__(self, caption: str, position: Any, scale: float, color: Any, font: Font, alignment: Alignment, shadow: bool, outline: bool) -> None: ...
    @overload
    def __init__(self, caption: str, position: Any, scale: float, color: Any, font: Font, alignment: Alignment, shadow: bool, outline: bool, wrapWidth: float) -> None: ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    @staticmethod
    def GetStringWidth(text: str, font: Font = ..., scale: float = 1.0) -> float: ...
    @staticmethod
    def GetScaledStringWidth(text: str, font: Font = ..., scale: float = 1.0) -> float: ...
    @overload
    def Draw(self) -> None: ...
    @overload
    def Draw(self, offset: Any) -> None: ...
    def Draw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def ScaledDraw(self) -> None: ...
    @overload
    def ScaledDraw(self, offset: Any) -> None: ...
    def ScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldDraw(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def WorldScaledDraw(self, position: Vector3) -> None: ...
    @overload
    def WorldScaledDraw(self, position: Vector3, offset: Any) -> None: ...
    def WorldScaledDraw(self, *args: Any, **kwargs: Any) -> Any: ...
